//
//  MCLicense.h
//  MCLicensing
//
//  Created by Michael Clark on Tue Feb 19 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface MCLicense : NSObject {
    NSString       *licenseString;
    NSString       *serialString;
    NSCalendarDate *productExpiry;
    NSCalendarDate *licenseExpiry;
    NSNumber       *numberOfUsers;
    int            featureMask;
    BOOL           isLicenseValid;
	NSString*      productCode;
	NSString*      versionCode;
}


- (id) initWithLicenseString: (NSString *) license_string
                serialString: (NSString *) serial_string;

// Accessors
- (NSString *)licenseString;
- (NSString *)serialString;
- (NSCalendarDate *)productExpiry;
- (NSCalendarDate *)licenseExpiry;
- (NSNumber *)numberOfUsers;
- (int)featureMask;
- (NSString*)productCode;
- (NSString*)versionCode;

- (BOOL)hasFeature:(int)aFeature;

// Checks
- (BOOL) isLicenseValid;
- (BOOL) isProductExpired;
- (BOOL) isLicenseActivationExpired;
- (NSInteger)numberOfDaysUntilProductExpiry;
- (BOOL)isValidForVersion: (NSString*)versionString;

// App name, i.e. "Daylite"
// Type string, i.e. "New Entry", or "Existing License Removed"
- (NSURL *)blacklistURLForApplicationString:(NSString *)appName typeString:(NSString *)typeStr;

- (NSString *)urlParameterStringRepresentation:(NSDictionary *)dict;

@end
